

import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;

public class RecMgrTest
{
	static void usage() {
		StringBuffer usg = new StringBuffer("usage: call with one of the following:\n");
		usg.append(" recs [user ID] <pcID 0> <pcID 1> ...<pcID n> -- get recs <from PC 0, etc.>\n");
		usg.append(" akx  [user ID]                               -- to get alkindex\n");
		System.out.println(usg);
		System.exit(1);
	}

	static void main(String[] args) {
		if (args.length < 1) {
				usage();
		}
		
		try {
			if (args.length < 2) {
				usage();
			}
			
			long uid = Long.parseLong(args[1]);
			
			IRecommendationManagerBean rmb = BeanUtil.getRecMgr();
			SystemUser su = new SystemUser(uid);
			if (args[0].compareTo("recs") == 0) {
				//	Parse Product Cluster List 
				//
				ProductClusterList pcList = null;
				if (args.length > 2) {
					System.out.println("Parsing PC List");
					for (int idx = 2; idx < args.length; idx ++) {
						pcList = new ProductClusterList();
						pcList.add(new ProductCluster(Integer.parseInt(args[idx])));
					}
				}
				for (int idx = 0; idx < 4; idx ++) {
					System.out.println("Getting recs for user " + uid);
					RecommendationList rl = null;
					if (pcList == null) 
						rl = rmb.getRecommendations(su, 4);
					else
						rl = rmb.getRecommendations(su, 4, pcList);

					if (null == rl) {
							System.out.println("No recommendations list returned.");
							return;
					}
					for (int recIdx = 0; recIdx < rl.size(); recIdx ++) {
						Product pr = rl.get(recIdx).prod;
						System.out.println("Recommended Product " + recIdx + " id=" + pr.id + " type=" + pr.type + " pred. rating=" + rl.get(recIdx).evaluation);
					}
				}
			}
			else if(args[0].compareTo("akx") == 0) {
				System.out.println("Getting alkindex for user " + uid + "...");
				double akx = rmb.getAlkindex(su);
				System.out.println("Alkindex = " + akx);
			}
			else {
				rmb.remove();
				usage();
			}
			rmb.remove();
		}
		catch (Exception e) {
			System.out.println(e.toString());
		}
		
	}



}

